/*
 * Decompiled with CFR 0.152.
 */
package com.zkryle.jeg.common.golem;

import com.zkryle.jeg.common.customgoals.PickSeedsUpGoal;
import com.zkryle.jeg.common.customgoals.PlantSeedsGoal;
import com.zkryle.jeg.core.Init;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PlantGolemEntity
extends CreatureEntity {
    private ItemStack seedSlot = new ItemStack((IItemProvider)Items.field_190931_a);
    @Nullable
    private UUID ownerUUID;

    public PlantGolemEntity(EntityType<? extends PlantGolemEntity> entityType, World level) {
        super(entityType, level);
    }

    public static PlantGolemEntity createGolem(@Nullable UUID ownerUUID, World level) {
        PlantGolemEntity golem = new PlantGolemEntity((EntityType<? extends PlantGolemEntity>)((EntityType)Init.PLANT_GOLEM_ENTITY.get()), level);
        golem.ownerUUID = ownerUUID;
        return golem;
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 15.0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new PlantSeedsGoal(this, 30, 0.3));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 5.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new PickSeedsUpGoal(this, 0.3));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.3));
        this.field_70714_bg.func_75776_a(6, (Goal)new PanicGoal((CreatureEntity)this, 0.5));
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (player.func_213453_ef() && !this.seedSlot.func_190926_b()) {
            this.dropSlotsLoot();
            this.field_70714_bg.func_220888_c().forEach(goal -> {
                if (goal.func_220772_j() instanceof PickSeedsUpGoal) {
                    PickSeedsUpGoal seedsgoal = (PickSeedsUpGoal)goal.func_220772_j();
                    seedsgoal.setDelay(40);
                }
            });
            this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    protected void func_213345_d(DamageSource source) {
        this.dropSlotsLoot();
        super.func_213345_d(source);
    }

    private void dropSlotsLoot() {
        this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_213303_ch().func_82615_a(), this.func_213303_ch().func_82617_b(), this.func_213303_ch().func_82616_c(), this.getSeedSlot()));
        this.setSeedSlot(new ItemStack((IItemProvider)Items.field_190931_a));
    }

    public ItemStack getSeedSlot() {
        return this.seedSlot;
    }

    public void setSeedSlot(ItemStack seedSlot) {
        this.seedSlot = seedSlot;
    }

    public boolean func_70039_c(CompoundNBT compound) {
        compound.func_218657_a("SeedSlot", (INBT)this.seedSlot.serializeNBT());
        if (this.ownerUUID != null) {
            compound.func_186854_a("ownerUUID", this.ownerUUID);
        }
        return super.func_70039_c(compound);
    }

    public void func_70020_e(CompoundNBT compound) {
        this.seedSlot = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("SeedSlot"));
        if (compound.func_186855_b("ownerUUID")) {
            this.ownerUUID = compound.func_186857_a("ownerUUID");
        }
        super.func_70020_e(compound);
    }

    public void func_70071_h_() {
        if (!this.seedSlot.func_190926_b()) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, this.seedSlot);
        }
        super.func_70071_h_();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)Init.PLANT_GOLEM_DIES.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return (SoundEvent)Init.PLANT_GOLEM_HURTS.get();
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a((SoundEvent)Init.PLANT_GOLEM_STEP.get(), this.func_70599_aP(), this.func_70647_i());
        super.func_180429_a(p_180429_1_, p_180429_2_);
    }

    public void func_70623_bb() {
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }
}

